/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.MarineFisherConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class MarineFisherTile
extends IndustrialAreaWorkingTile<MarineFisherTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedInventoryComponent<MarineFisherTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 50, 22, 18, 0).setColor(DyeColor.ORANGE).setRange(6, 3).setComponentHarness((IComponentHarness)this);

    public MarineFisherTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.MARINE_FISHER, RangeManager.RangeType.BOTTOM, false, MarineFisherConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.output);
        this.maxProgress = MarineFisherConfig.maxProgress;
        this.powerPerOperation = MarineFisherConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.powerPerOperation)) {
            if (this.getWaterSources() < 9) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            LootTable fishingTable = this.f_58857_.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78720_);
            if (this.f_58857_.f_46441_.nextDouble() <= 0.02) {
                fishingTable = this.f_58857_.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78722_);
            }
            LootContext.Builder context = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42523_));
            fishingTable.m_79129_(context.m_78975_(LootContextParamSets.f_81414_)).forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.powerPerOperation);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<MarineFisherTile> createEnergyStorage() {
        return new EnergyStorageComponent(MarineFisherConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public MarineFisherTile getSelf() {
        return this;
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.f_58858_, this.getFacingDirection(), RangeManager.RangeType.BOTTOM).get(1);
    }

    private int getWaterSources() {
        int amount = 0;
        for (BlockPos pos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().m_83215_())) {
            FluidState fluidState;
            if (!this.f_58857_.m_46832_(pos, pos) || !(fluidState = this.f_58857_.m_6425_(pos)).m_76152_().equals(Fluids.f_76193_) || !fluidState.m_76170_()) continue;
            ++amount;
        }
        return amount;
    }
}

